﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Inet.Viewer.Data;
using Inet.Viewer.WinForms;
using Inet.Viewer.WinForms.Prompt;
using System.Windows.Forms;

namespace Inet.Viewer.test.WinForms
{
    [TestFixture]
    class TestSinglePromptValuePanelWithDefaultValues
    {
        [Test]
        public void TestSingleWithDefaultValues()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] {"a","b" },
                new string[] {"desca","descb" },
                PromptData.String, true, false, false, true, false,
                false, null, null, null);

            SinglePromptFieldWithDefaultValues f = new SinglePromptFieldWithDefaultValues(p1);
            Assert.AreEqual(2, f.cmbDefaultValues.Items.Count);

            PromptValue v = f.Value;
            Assert.AreEqual("'a'", v.StringRepresentation);

            f.chkNoValue.Checked = true;
            Assert.IsNull(f.Value.Value);

            f.chkNoValue.Checked = false;
            v = f.Value;
            Assert.AreEqual("'a'", v.StringRepresentation);
            Assert.AreNotEqual(ComboBoxStyle.DropDownList, f.cmbDefaultValues.DropDownStyle);
            Assert.IsTrue(f.chkNoValue.Visible);

        }
        [Test]
        public void TestDefaultValuesOnly()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] {"a","b" },
                new string[] {"desca","descb" },
                PromptData.String, true, false, false, false, false,
                false, null, null, null);
            SinglePromptFieldWithDefaultValues f = new SinglePromptFieldWithDefaultValues(p1);
            Assert.AreEqual(2, f.cmbDefaultValues.Items.Count);
            Assert.AreEqual(ComboBoxStyle.DropDownList, f.cmbDefaultValues.DropDownStyle);
            Assert.IsFalse(f.chkNoValue.Visible);
        }
    }
}
